% Data acquisition functions (comedi interface)
% Comedi is a general interface for many different data acquisition
% cards under Linux.  See http://stm.lbl.gov/comedi.
% These functions allow you to access some of the comedi library
% from MATLAB.
%
% Device management
%   comedi_open          - Open device 
%   comedi_isopen        - Query whether device is open
%   comedi_close         - Close device
%   comedi_find_subdevice_by_type  - Find subdevice numbers
%   comedi_get_subdevice_type      - Find type given a subdevice number
%   comedi_get_max_buffer_size     - Useful for streaming data
%   comedi_set_buffer_size         - Adjust the buffer size (streaming)
%   comedi_get_n_ranges  - Determine number of A/D voltage ranges
%   comedi_get_range     - Determine the nth A/D voltage range
%   comedi_find_range    - Find corresponding range index
%   comedi_dio_config    - Configure digital I/O channel direction
%
% Data acquisition
%   comedi_data_read     - Perform a single A/D conversion
%   comedi_command       - Initiate a board-autonomous command (streaming)
%   comedi_command_test  - Check and adjust parameters of a command
%   comedibuf_read       - Acquire data from a command
%   comedi_cancel_and_flush        - Terminate a command
%
% Digital sample control
%   comedi_dio_bitfield  - Set and get multiple digital channels simultaneously
%
% Example MATLAB scripts
%   make_comedi_cmd      - Prepare a default command
%   comcmd               - A complete (simple) example using commands
