/*
 * Adapted from common.c in comedilib/demo/common.c
 */

#include <stdio.h>
#include <comedilib.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <getopt.h>
#include <ctype.h>
#include <malloc.h>
#include <string.h>
#include <stdlib.h>

char *filename="/dev/comedi0";
int verbose;

int value=0;
int subdevice=1; // 0 is for DIO subdevice
int channel=0;
int aref=AREF_GROUND; // Doesn't matter for counter subd
int range=0; // Doesn't matter for counter subd
int n_chan=8; // For ni_6602!
int n_scan=1000; // Currently not implemented
double freq=1000.0; // Currently not implemented
int gpct_x=1; // Standard X1 encoding (can be 2/4)


int parse_options(int argc, char *argv[])
{
  int c;


  while (-1 != (c = getopt(argc, argv, "a:c:s:r:f:n:N:F:x:vdgom"))) {
    switch (c) {
    case 'f':
      filename = optarg;
      break;
    case 's':
      subdevice = strtoul(optarg,NULL,0);
      break;
    case 'c':
      channel = strtoul(optarg,NULL,0);
      break;
    case 'a':
      aref = strtoul(optarg,NULL,0);
      break;
    case 'r':
      range = strtoul(optarg,NULL,0);
      break;
    case 'n':
      n_chan = strtoul(optarg,NULL,0);
      break;
    case 'N':
      n_scan = strtoul(optarg,NULL,0);
      break;
    case 'F':
      freq = strtoul(optarg,NULL,0);
      break;
    case 'x': /* Added by me myself and I
		 x can be 1, 2, or 4 */
      gpct_x = strtoul(optarg,NULL,0);
      break;
    case 'v':
      verbose = 1;
      break;
    case 'd':
      aref = AREF_DIFF;
      break;
    case 'g':
      aref = AREF_GROUND;
      break;
    case 'o':
      aref = AREF_OTHER;
      break;
    case 'm':
      aref = AREF_COMMON;
      break;
    default:
      printf("bad option\n");
      exit(1);
    }
  }
  if(optind < argc) {
    /* data value */
    sscanf(argv[optind++],"%d",&value);
  }

  return argc;
}

