// $Id: encodertest.c,v 1.7 2003/04/15 11:21:46 kgadeyne Exp $
/*
** Copyright (C) 2003 Klaas Gadeyne <klaas.gadeyne@mech.kuleuven.ac.be>
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/

/* Test program for the ni660x comedi-driver. Tests the GPCT/encoder
   subdevice.  See "common.h" for possible command-line options.
*/

#include <stdio.h>
#include <comedi.h>
#include <comedilib.h>
#include <unistd.h>

/* Include the constant typical of this device that are not yet
   defined in comedi
   You might hive to adapt this path!!
*/
#include "../ni660x.h"
/* For the parse_options function (parsing the options added to main)
   */ 
#include "common.h"

#define MAX_SAMPLES 20 // Number of samples to read
#define NI_660x_COUNTER_SUBD 1 // Subdevice 1 is the counter

/* The number of configuration parameters for turning a GPCT subdevice
   into an encoder
   Not yet accepted in comedi as a standard.  Proposed by Herman
   Bruyninckx on the Mailinglist [TODO: Add link (website currently
   down)
   data[0] = Application of the counter, ic. GPCT_QUADRATURE_ENCODER
   data[1] = Mode in which the encoder is used, ic GPCT_X1, GPCT_X2 or
   GPCT_X4 (0x01, Ox02, 0x04)

*/
#define ENCODER_CONFIG_DATA 2
#define INSN_LIST_NUM_INS 4 // The number of instructions in our list

int main(int argc, char *argv[])
{
  comedi_t * device;
  int ret,i;
  comedi_insn insn[INSN_LIST_NUM_INS]; // List of instructions
  comedi_insnlist il;

  struct timeval t1,t2; // Start en end time
  lsampl_t config_data[ENCODER_CONFIG_DATA]; // Configuration data
  lsampl_t data[MAX_SAMPLES]; // Read data

  parse_options(argc,argv);
  // Check Subdevice :-)
  if (subdevice != NI_660x_COUNTER_SUBD)
    {
      printf("You're not using the counter subdevice (%d)!\n", NI_660x_COUNTER_SUBD);
      exit(0);
    }
  printf("Are you sure you're using encoder %d?\n",channel);
  if ( (gpct_x != 1) && (gpct_x != 2) && (gpct_x != 4))
    {
      printf("gpct_x should be 1,2, or 4!\n");
      exit(0);
    }

  device=comedi_open(filename);
  if(!device)
    {
      printf("Error opening Comedi Device\n");
      comedi_perror(filename);
      exit(0);
    }
  
  /* Set up a the "instruction list", which is just a pointer
   * to the array of instructions and the number of instructions.
   */
  il.n_insns=INSN_LIST_NUM_INS;
  il.insns=insn;


  /* Instruction 0: perform a gettimeofday() */
  insn[0].insn=INSN_GTOD;
  insn[0].n=2;
  insn[0].data=(void *)&t1;

  /* Instruction 1: Configure the GPCT for use as an encoder */
  insn[1].insn=INSN_CONFIG;
  insn[1].n=0; // Irrelevant for config
  config_data[0] = GPCT_QUADRATURE_ENCODER;
  config_data[1] = gpct_x;
  insn[1].data=config_data;
  insn[1].subdev=subdevice;
  insn[1].chanspec=CR_PACK(channel,0,0);

  /* 
     ret=comedi_do_insn(device,&(insn[1]));
     if(ret<0)
     {
     printf("Encodertest.c: Config Failed\n");
     comedi_perror(filename);
     exit(0);
     } 
  */

  /* Instruction 3: Read the encoder MAXSAMPLES times */
  insn[2].insn=INSN_READ;
  insn[2].n=MAX_SAMPLES;
  insn[2].data=data;
  insn[2].subdev=subdevice;
  insn[2].chanspec=CR_PACK(channel,0,0);

  /*   
     ret=comedi_do_insn(device,&(insn[2]));
     if(ret<0)
     {
     printf("Encodertest.c: Read encoder data failed\n");
     comedi_perror(filename);
     exit(0);
     } 
  */

  /* Instruction 4: perform a gettimeofday() */
  insn[3].insn=INSN_GTOD;
  insn[3].n=2;
  insn[3].data=(void *)&t2;

  ret=comedi_do_insnlist(device,&il);
  if(ret<0)
    {
      printf("encodertest.c: Instruction list did not complete");
      printf(" successfully\n");
      comedi_perror(filename);
      exit(0);
    }

  printf("encodertest.c: initial time: %ld.%06ld\n",
	 t1.tv_sec,t1.tv_usec);
  printf("encodertest.c: final time: %ld.%06ld\n",
	 t2.tv_sec,t2.tv_usec);
  printf("encodertest.c: elapsed (us): %ld\n",
	 (t2.tv_sec-t1.tv_sec)*1000000+(t2.tv_usec-t1.tv_usec));

  printf("encodertest.c: Encoder data\n");
  for (i = 0; i < MAX_SAMPLES ; i++ )
  {
    printf("data[%d] = %d\n",i,(int) data[i]); 
  }
  
  printf("encodertest.c: Sleeping 2 seconds...\n");
  usleep(2000000);
  printf("encodertest.c: Trying comedi_data_read now...\n");
  ret=comedi_data_read(device,NI_660x_COUNTER_SUBD,channel,
		   0,0,data);
  if(ret<0)
    {
      printf("encodertest.c: comedi_data_read did not complete\n");
      comedi_perror(filename);
      exit(0);
    }
  printf("data = %d\n",(int) data[0]);

  printf("encodertest.c: Trying comedi_data_write now...\n");
  ret=comedi_data_write(device,NI_660x_COUNTER_SUBD,channel,
		       0,0,(lsampl_t) 0x1);
  if(ret<0)
    {
      printf("encodertest.c: comedi_data_write didn't work\n");
      comedi_perror(filename);
      exit(0);
    }

  printf("encodertest.c: Reading the new value...\n");
  ret=comedi_data_read(device,NI_660x_COUNTER_SUBD,channel,
		       0,0,data);
  if(ret<0)
    {
      printf("encodertest.c: comedi_data_read dit not complete\nx");
      comedi_perror(filename);
      exit(0);
    }
  printf("data = %d\n",(int) data[0]);
  
  return 0;
}
